<?php

namespace App\Filament\Pages;

use Filament\Pages\Page;
use Filament\Notifications\Notification;
use Illuminate\Support\Facades\Auth;

class DeveloperApi extends Page
{
    protected static ?string $navigationIcon = 'heroicon-o-code-bracket';
    protected static ?string $navigationLabel = 'بوابة المطورين (API)';
    protected static ?string $title = 'Developer API & Integration';
    protected static ?int $navigationSort = 10;
    protected static string $view = 'filament.pages.developer-api';

    public $token = null;

    // دالة لتوليد توكن جديد
    public function generateToken()
    {
        $user = Auth::user();
        
        // حذف التوكنات القديمة للأمان (اختياري)
        $user->tokens()->delete();
        
        // إنشاء توكن جديد
        $newToken = $user->createToken('External API')->plainTextToken;
        
        $this->token = $newToken;

        Notification::make()
            ->title('تم إنشاء مفتاح API جديد')
            ->body('يرجى نسخ المفتاح الآن، لن تتمكن من رؤيته مرة أخرى.')
            ->success()
            ->send();
    }
}