<?php

namespace App\Filament\Pages;

use Filament\Pages\Page;
use App\Models\Message;
use App\Models\WhatsAppAccount;
use App\Services\WhatsAppService;
use Illuminate\Support\Facades\Auth;

class LiveChat extends Page
{
    protected static ?string $navigationIcon = 'heroicon-o-chat-bubble-left-right';
    protected static ?string $navigationLabel = 'المحادثات المباشرة';
    protected static ?string $title = 'Live Chat';
    protected static ?int $navigationSort = 2;
    protected static string $view = 'filament.pages.live-chat';

    // المتغيرات
    public $selectedAccount;
    public $selectedPhone = null; // العميل المختار حالياً
    public $messageBody = ''; // نص الرسالة الجديد
    
    // لتحديث الشات تلقائياً (Polling)
    protected $listeners = ['refreshComponent' => '$refresh'];

    public function mount()
    {
        // اختيار أول حساب واتساب للمستخدم افتراضياً
        $this->selectedAccount = WhatsAppAccount::where('user_id', Auth::id())->first();
    }

    // جلب قائمة العملاء الذين راسلونا (للقائمة الجانبية)
    public function getConversationsProperty()
    {
        if (!$this->selectedAccount) return [];

        return Message::where('whatsapp_account_id', $this->selectedAccount->id)
            ->select('phone')
            ->distinct()
            ->latest() // الأحدث أولاً
            ->get();
    }

    // جلب رسائل العميل المختار
    public function getMessagesProperty()
    {
        if (!$this->selectedPhone || !$this->selectedAccount) return [];

        return Message::where('whatsapp_account_id', $this->selectedAccount->id)
            ->where('phone', $this->selectedPhone)
            ->orderBy('created_at', 'asc')
            ->get();
    }

    // تحديد عميل عند الضغط عليه
    public function selectContact($phone)
    {
        $this->selectedPhone = $phone;
        // هنا يمكن تصفير عداد الرسائل غير المقروءة مستقبلاً
    }

    // إرسال رسالة
    public function sendMessage()
    {
        if (empty($this->messageBody) || !$this->selectedPhone) return;

        // 1. الإرسال عبر API
        $whatsappService = new WhatsAppService();
        $whatsappService->sendTemplate( // أو دالة sendText عادية لو أضفتها
            $this->selectedAccount->phone_number_id,
            $this->selectedAccount->access_token,
            $this->selectedPhone,
            null, null, // هنا نحتاج لتعديل الخدمة لتدعم النصوص الحرة، سنفترض وجود دالة sendText
            $this->messageBody 
        );

        // 2. الحفظ في قاعدة البيانات
        Message::create([
            'whatsapp_account_id' => $this->selectedAccount->id,
            'phone' => $this->selectedPhone,
            'body' => $this->messageBody,
            'direction' => 'outgoing',
            'status' => 'sent',
        ]);

        $this->messageBody = ''; // تنظيف الحقل
    }
}