<?php

namespace App\Filament\Pages;

use App\Settings\GeneralSettings;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\ColorPicker;
use Filament\Forms\Components\Textarea;

class ManageGeneralSettings extends SettingsPage
{
    protected static ?string $navigationIcon = 'heroicon-o-cog-6-tooth';
    protected static ?string $navigationLabel = 'إعدادات النظام';
    protected static ?string $title = 'الإعدادات العامة';
    protected static ?int $navigationSort = 100; // ستظهر في أسفل القائمة
    
    protected static string $settings = GeneralSettings::class;

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                // --- قسم الهوية البصرية ---
                Section::make('الهوية البصرية')
                    ->description('شعار الموقع واسمه وألوانه')
                    ->schema([
                        TextInput::make('site_name')
                            ->label('اسم الموقع')
                            ->required()
                            ->columnSpan(2),
                            
                        FileUpload::make('site_logo')
                            ->label('الشعار (Logo)')
                            ->image()
                            ->directory('settings')
                            ->preserveFilenames()
                            ->columnSpan(2),
                            
                        ColorPicker::make('brand_color')
                            ->label('لون البراند الرئيسي'),
                    ])->columns(2),

                // --- قسم العملات والمنطقة ---
                Section::make('الإعدادات الإقليمية')
                    ->schema([
                        Select::make('default_currency')
                            ->label('العملة الافتراضية')
                            ->options([
                                'SAR' => 'ريال سعودي (SAR)',
                                'USD' => 'دولار أمريكي (USD)',
                                'EGP' => 'جنيه مصري (EGP)',
                                'AED' => 'درهم إماراتي (AED)',
                                'KWD' => 'دينار كويتي (KWD)',
                            ])
                            ->searchable()
                            ->required(),

                        Select::make('timezone')
                            ->label('التوقيت الزمني')
                            ->options([
                                'Asia/Riyadh' => 'الرياض (GMT+3)',
                                'Africa/Cairo' => 'القاهرة (GMT+2)',
                                'Asia/Dubai' => 'دبي (GMT+4)',
                                'UTC' => 'توقيت عالمي (UTC)',
                            ])
                            ->required(),
                    ])->columns(2),

                // --- قسم النصوص والترجمة ---
                Section::make('تخصيص الواجهة')
                    ->schema([
                        TextInput::make('login_page_text')
                            ->label('عنوان صفحة تسجيل الدخول')
                            ->placeholder('مثلاً: مرحباً بك في أقوى منصة تسويق'),
                        
                        TextInput::make('support_email')
                            ->label('بريد الدعم الفني')
                            ->email(),

                        Textarea::make('footer_text')
                            ->label('نص الحقوق (Footer)')
                            ->rows(2),
                    ]),
            ]);
    }
}