<?php

namespace App\Filament\Pages;

use Filament\Pages\Page;
use Illuminate\Support\Facades\Auth;
use App\Models\Contact;
// ⚠️ إذا لم يتم استخدام CampaignLog حالياً لاحتساب الرصيد، لن نحتاجه هنا.
// سنعتمد على حقل credits في موديل User.
// use App\Models\CampaignLog; 
use App\Models\WhatsAppAccount;

class MySubscription extends Page
{
    protected static ?string $navigationIcon = 'heroicon-o-credit-card';
    protected static ?string $navigationLabel = 'اشتراكي واستهلاكي';
    protected static ?string $title = 'تفاصيل الباقة والاستهلاك';
    protected static ?int $navigationSort = 10;
    protected static string $view = 'filament.pages.my-subscription';

    public $user;
    public $usage = [];

    public function mount()
    {
        $this->user = Auth::user();
        
        if (!$this->user->package) {
            return;
        }

        // حساب الاستهلاكات
        $this->usage = [
            'contacts' => [
                'label' => 'جهات الاتصال',
                'used' => Contact::where('user_id', $this->user->id)->count(),
                'limit' => $this->user->package->limit_contacts,
            ],
            // 🔑 التصحيح: عرض الرصيد المتبقي الفعلي من موديل المستخدم
            'current_credits' => [
                'label' => 'رصيد الرسائل المتبقي',
                'current' => $this->user->credits, // 🔑 الرصيد المتبقي فعلياً
            ],
            // 🔑 إضافة حد الرسائل الشهري/للباقة (إذا كان يمثل حد Quota شهرياً)
            'package_messages_limit' => [
                'label' => 'حد رسائل الباقة (شهري/إجمالي)',
                // ⚠️ يجب تحديد الاستخدام الفعلي لهذا الحد إذا كان رولينج كوتا (Rolling Quota)
                // حالياً، سنعرضه كحد فقط.
                'limit' => $this->user->package->limit_messages,
            ],
            'accounts' => [
                'label' => 'حسابات واتساب',
                'used' => WhatsAppAccount::where('user_id', $this->user->id)->count(),
                'limit' => $this->user->package->limit_wa_accounts,
            ],
        ];
    }
}