<?php

namespace App\Filament\Resources\CampaignResource\Pages;

use App\Filament\Resources\CampaignResource;
use Filament\Resources\Pages\CreateRecord;

class CreateCampaign extends CreateRecord
{
    protected static string $resource = CampaignResource::class;

    /**
     * هذه الدالة تعمل تلقائياً قبل حفظ البيانات في قاعدة البيانات
     * نستخدمها لضبط الحالة وتعيين المستخدم
     */
    protected function mutateFormDataBeforeCreate(array $data): array
    {
        // 1. ضمان ربط الحملة بالمستخدم الحالي
        $data['user_id'] = auth()->id();

        // 2. منطق الجدولة الذكي
        // إذا كان حقل "وقت الجدولة" ممتلئاً
        if (!empty($data['scheduled_at'])) {
            // نغير الحالة إلى "مجدولة" ليتم التقاطها بواسطة الـ Cron Job
            $data['status'] = 'scheduled';
        } else {
            // وإلا، نجعلها "معلقة" بانتظار التشغيل اليدوي
            $data['status'] = 'pending';
        }

        // 3. تصفير العدادات عند البدء (للنظافة)
        $data['success_count'] = 0;
        $data['failed_count'] = 0;
        $data['total_contacts'] = 0;

        return $data;
    }

    /**
     * (اختياري) التوجيه بعد الإنشاء
     * العودة لجدول الحملات بدلاً من البقاء في نفس الصفحة
     */
    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }
}