<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ContactResource\Pages;
use App\Models\Contact;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Hidden;
use Filament\Tables\Columns\TextColumn;

class ContactResource extends Resource
{
    protected static ?string $model = Contact::class;

    protected static ?string $navigationIcon = 'heroicon-o-users'; // أيقونة المستخدمين
    
    protected static ?string $navigationLabel = 'جهات الاتصال';
    
    protected static ?string $modelLabel = 'جهة اتصال';
    
    // ترتيب ظهورها في القائمة (رقم 2 بعد الحسابات)
    protected static ?int $navigationSort = 2; 

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                // تعبئة معرف المستخدم تلقائياً
                Hidden::make('user_id')
                    ->default(fn () => auth()->id())
                    ->required(),

                TextInput::make('name')
                    ->label('اسم العميل')
                    ->placeholder('مثلاً: محمد أحمد')
                    ->required(),

                TextInput::make('phone')
                    ->label('رقم الهاتف (مع الدولة)')
                    ->placeholder('9665xxxxxxxx')
                    ->tel()
                    ->required()
                    // التحقق من عدم تكرار الرقم لهذا المستخدم فقط
                    ->unique(modifyRuleUsing: function ($rule) {
                        return $rule->where('user_id', auth()->id());
                    }, ignoreRecord: true),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('name')
                    ->label('الاسم')
                    ->searchable()
                    ->sortable(),

                TextColumn::make('phone')
                    ->label('الهاتف')
                    ->searchable()
                    ->copyable()
                    ->icon('heroicon-m-phone'),

                TextColumn::make('created_at')
                    ->label('تاريخ الإضافة')
                    ->dateTime()
                    ->sortable(),
            ])
            ->filters([
                // يمكن إضافة فلتر بالتاريخ هنا
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    // أهم دالة: عزل البيانات
    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()->where('user_id', auth()->id());
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListContacts::route('/'),
            'create' => Pages\CreateContact::route('/create'),
            'edit' => Pages\EditContact::route('/{record}/edit'),
        ];
    }
}