<?php

namespace App\Filament\Resources;

use App\Filament\Resources\PlanResource\Pages;
use App\Models\Plan;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables\Table;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Repeater;
// استيراد الأعمدة الضرورية للجدول
use Filament\Tables\Columns\TextColumn; 
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;
use Filament\Tables\Actions\EditAction;

class PlanResource extends Resource
{
    protected static ?string $model = Plan::class;
    protected static ?string $navigationIcon = 'heroicon-o-currency-dollar';
    protected static ?string $navigationGroup = 'إعدادات النظام';
    protected static ?string $modelLabel = 'باقة اشتراك';
    protected static ?string $pluralModelLabel = 'باقات الاشتراك';
    // تحديد ترتيب العرض (اختياري)
    protected static ?int $navigationSort = 1; 

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('name_ar')
                    ->label('اسم الباقة (العربية)')
                    ->required()
                    ->maxLength(255),
                TextInput::make('price')
                    ->label('السعر الشهري (بالريال مثلاً)')
                    ->numeric()
                    ->prefix('ر.س')
                    ->required(),
                
                TextInput::make('max_whatsapp_accounts')
                    ->label('حد حسابات الواتساب')
                    ->numeric()
                    ->required(),
                TextInput::make('monthly_credits')
                    ->label('الرصيد الشهري / عدد الرسائل')
                    ->numeric()
                    ->required(),
                
                // 🔑 استخدام Repeater لقائمة الميزات (يُخزن كـ JSON)
                Repeater::make('features_ar')
                    ->label('ميزات الباقة (العربية)')
                    ->schema([
                        TextInput::make('feature')
                            ->label('الميزة')
                            ->required(),
                    ])
                    ->reorderable()
                    ->defaultItems(3)
                    ->minItems(1)
                    ->columnSpanFull(),

                Toggle::make('is_recommended')
                    ->label('الباقة الموصى بها')
                    ->helperText('يتم تمييز هذه الباقة في صفحة الهبوط.'),
                Toggle::make('is_visible')
                    ->label('مرئية في صفحة الهبوط')
                    ->default(true),
            ])->columns(2);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                // 🔑 الأعمدة الضرورية لصفحة القائمة (Index)
                TextColumn::make('name_ar')
                    ->label('اسم الباقة')
                    ->searchable()
                    ->sortable(),
                
                TextColumn::make('price')
                    ->label('السعر')
                    ->money('SAR') // عرض العملة
                    ->sortable(),
                
                TextColumn::make('monthly_credits')
                    ->label('الرصيد')
                    ->numeric()
                    ->sortable(),

                IconColumn::make('is_recommended')
                    ->label('موصى بها')
                    ->boolean(),

                IconColumn::make('is_visible')
                    ->label('مرئية')
                    ->boolean(),

            ])
            ->filters([
                // يمكن إضافة فلاتر هنا
            ])
            ->actions([
                EditAction::make(),
            ])
            ->bulkActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
    
    // 🔑 تعريف الصفحات (Pages)
    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPlans::route('/'),
            'create' => Pages\CreatePlan::route('/create'),
            'edit' => Pages\EditPlan::route('/{record}/edit'),
        ];
    }
}