<?php

namespace App\Filament\Resources;

use App\Filament\Resources\WhatsappTemplateResource\Pages;
use App\Models\WhatsappTemplate;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables\Table;

use Illuminate\Database\Eloquent\Builder; 
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Columns\BadgeColumn;
use Filament\Tables\Filters\SelectFilter;
use Filament\Tables\Actions\ViewAction;
use Filament\Tables\Actions\DeleteAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;
use Filament\Support\Colors\Color;


class WhatsappTemplateResource extends Resource
{
    protected static ?string $model = WhatsappTemplate::class;

    protected static ?string $navigationIcon = 'heroicon-o-chat-bubble-left-right';
    protected static ?string $navigationGroup = 'حسابات الواتساب';
    protected static ?string $navigationLabel = 'قوالب الرسائل';
    protected static ?string $modelLabel = 'قالب رسالة';
    protected static ?int $navigationSort = 2;


    public static function form(Form $form): Form
    {
        // القوالب للقراءة فقط، تُنشأ في Meta
        return $form->schema([]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('name')
                    ->label('اسم القالب')
                    ->searchable()
                    ->sortable(),

                TextColumn::make('whatsappAccount.name')
                    ->label('حساب الواتساب')
                    ->searchable(),

                TextColumn::make('language')
                    ->label('اللغة')
                    ->badge(),

                BadgeColumn::make('status')
                    ->label('الحالة')
                    ->colors([
                        'success' => Color::Green,
                        'danger' => Color::Red,
                        'warning' => Color::Amber,
                    ])
                    ->sortable(),

                TextColumn::make('category')
                    ->label('الفئة')
                    ->sortable(),
                    
                TextColumn::make('updated_at')
                    ->label('آخر تحديث')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                SelectFilter::make('status')
                    ->label('حالة القالب')
                    ->options([
                        'APPROVED' => 'موافق عليه',
                        'REJECTED' => 'مرفوض',
                        'PENDING' => 'قيد المراجعة',
                    ]),
                SelectFilter::make('whatsapp_account_id')
                    ->label('حساب الواتساب')
                    ->relationship('whatsappAccount', 'name'),
            ])
            ->actions([
                ViewAction::make(),
                DeleteAction::make(),
            ])
            ->bulkActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
    
    // 🚀 تطبيق منطق عرض البيانات حسب المستخدم (عزل البيانات) وتحميل العلاقة مسبقاً
    public static function getEloquentQuery(): Builder
    {
        $query = parent::getEloquentQuery();
        
        // 🔑 التحميل المسبق للعلاقة لضمان عرضها في شاشة View
        $query->with('whatsappAccount');

        if (auth()->user()->hasRole('Super Admin')) {
            return $query;
        }

        return $query->whereHas('whatsappAccount', function (Builder $q) {
            $q->where('user_id', auth()->id());
        });
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListWhatsappTemplates::route('/'),
            // 🔑 صفحة العرض التفصيلي
            'view' => Pages\ViewWhatsappTemplate::route('/{record}'), 
        ];
    }
}