<?php

namespace App\Http\Controllers;

use App\Models\Plan;
use App\Models\LandingPageSetting;
use Illuminate\Http\Request;

class LandingPageController extends Controller
{
    public function index()
    {
        // جلب الإعدادات (Singular Model)
        $settings = LandingPageSetting::getSettings(); 

        // جلب الباقات المرئية ومرتبة
        $plans = Plan::where('is_visible', true)
                     ->orderBy('price')
                     ->get();

        return view('landing', compact('settings', 'plans'));
    }
}