<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Contact extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'name',
        'phone',
        'data',
    ];

    protected $casts = [
        'data' => 'array', // تحويل الـ JSON لمصفوفة تلقائياً
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}