<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Plan extends Model
{
    use HasFactory;

    protected $fillable = [
        'name_ar',
        'name_en',
        'price',
        'max_whatsapp_accounts',
        'monthly_credits',
        'features_ar',
        'features_en',
        'is_visible',
        'is_recommended',
    ];

    protected $casts = [
        'features_ar' => 'array',
        'features_en' => 'array',
        'is_visible' => 'boolean',
        'is_recommended' => 'boolean',
    ];

    // إضافة علاقة لربط المستخدمين بالباقات
    public function users()
    {
        return $this->hasMany(User::class);
    }
}