<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // لاحظ الاسم هنا: whatsapp_accounts (بدون فواصل ليتطابق مع الموديل)
        Schema::create('whatsapp_accounts', function (Blueprint $table) {
            $table->id();
            
            // ربط الحساب بالمستخدم (صاحب المنصة أو العميل)
            // cascadeOnDelete تعني: لو حذفنا المستخدم، تحذف حساباته تلقائياً
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            
            $table->string('name'); // اسم للحساب للتمييز
            $table->string('phone_number_id'); // معرف الرقم من فيسبوك
            $table->string('waba_id')->nullable(); // معرف البيزنس (اختياري)
            $table->text('access_token'); // التوكين (text لأنه طويل جداً)
            $table->boolean('is_active')->default(true); // حالة الحساب
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('whatsapp_accounts');
    }
};