<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
  public function up(): void
{
    Schema::create('packages', function (Blueprint $table) {
        $table->id();
        
        // --- 1. المعلومات الأساسية والتسعير ---
        $table->string('name'); // اسم الباقة (Basic, Premium, Enterprise)
        $table->string('slug')->unique(); // اسم برمجي (basic_monthly)
        $table->text('description')->nullable(); // وصف قصير للتسويق
        $table->decimal('price', 10, 2); // السعر
        $table->integer('duration_days')->default(30); // مدة الباقة (30 = شهر، 365 = سنة)
        $table->boolean('is_visible')->default(true); // هل تظهر في صفحة الأسعار؟
        $table->boolean('is_popular')->default(false); // هل نضع عليها شريط "الأكثر مبيعاً"؟
        $table->integer('sort_order')->default(0); // ترتيب الظهور

        // --- 2. القيود الرقمية (Quotas) - (0 تعني غير محدود) ---
        $table->integer('limit_messages')->default(1000); // رصيد الرسائل
        $table->integer('limit_contacts')->default(500); // عدد العملاء
        $table->integer('limit_campaigns')->default(5); // عدد الحملات المتزامنة
        $table->integer('limit_wa_accounts')->default(1); // عدد أرقام الواتساب المربوطة
        $table->integer('limit_team_members')->default(0); // هل يمكنه إضافة موظفين معه؟
        $table->integer('limit_storage_mb')->default(100); // مساحة التخزين (للصور والفيديوهات)

        // --- 3. الميزات التقنية (Features / Booleans) ---
        // هذه تحدد: هل يظهر الزر للمستخدم أم لا؟
        $table->boolean('has_api_access')->default(false); // هل لديه صلاحية API؟
        $table->boolean('has_chatbot')->default(false); // هل يمكنه استخدام الشات بوت؟
        $table->boolean('has_media_upload')->default(true); // هل يمكنه إرسال صور وفيديو؟
        $table->boolean('has_schedule_campaigns')->default(true); // جدولة الحملات
        $table->boolean('has_excel_export')->default(false); // تصدير التقارير Excel
        $table->boolean('has_priority_support')->default(false); // دعم فني سريع
        $table->boolean('remove_branding')->default(false); // إزالة شعار "Powered by WhatsMark"

        $table->timestamps();
    });
}
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('packages');
    }
};
