<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            
            // 1. إضافة عمود الباقة (Package) إذا لم يكن موجوداً
            if (!Schema::hasColumn('users', 'package_id')) {
                // نستخدم nullable لأنه قد يوجد مستخدمين سابقين بدون باقة
                $table->foreignId('package_id')->nullable()->constrained('packages')->nullOnDelete();
            }

            // 2. إضافة عمود الرصيد (Credits)
            if (!Schema::hasColumn('users', 'credits')) {
                $table->integer('credits')->default(0);
            }

            // 3. إضافة تاريخ انتهاء الاشتراك
            if (!Schema::hasColumn('users', 'subscription_ends_at')) {
                $table->date('subscription_ends_at')->nullable();
            }

            // 4. إضافة حالة التفعيل (Active)
            if (!Schema::hasColumn('users', 'is_active')) {
                $table->boolean('is_active')->default(true);
            }

            // 5. إضافة الملاحظات
            if (!Schema::hasColumn('users', 'notes')) {
                $table->text('notes')->nullable();
            }
        });
    }

    public function down(): void
    {
        // عند التراجع نحذف الأعمدة
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'package_id', 
                'credits', 
                'subscription_ends_at', 
                'is_active', 
                'notes'
            ]);
        });
    }
};