<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
public function up(): void
{
    Schema::create('messages', function (Blueprint $table) {
        $table->id();
        // الحساب الذي تم الإرسال منه/إليه
        $table->foreignId('whatsapp_account_id')->constrained()->cascadeOnDelete();
        
        $table->string('phone'); // رقم العميل
        $table->text('body')->nullable(); // نص الرسالة
        $table->string('type')->default('text'); // text, image, video
        $table->enum('direction', ['incoming', 'outgoing']); // وارد أم صادر
        $table->string('wa_id')->nullable()->unique(); // معرف الرسالة من واتساب (لمنع التكرار)
        $table->string('status')->default('sent'); // sent, delivered, read
        $table->boolean('is_read')->default(false); // هل قرأها الموظف؟
        
        $table->timestamps();
    });
}
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('messages');
    }
};
