<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
{
    Schema::create('whatsapp_templates', function (Blueprint $table) {
        $table->id();
        $table->foreignId('whatsapp_account_id')->constrained()->cascadeOnDelete();
        
        $table->string('name'); // اسم القالب البرمجي
        $table->string('language'); // ar, en_US
        $table->string('status'); // APPROVED, REJECTED, PENDING
        $table->string('category')->nullable(); // MARKETING, UTILITY
        
        // سنخزن هيكل القالب كاملاً (JSON) لنعرضه كـ معاينة (Preview) لاحقاً
        $table->json('components')->nullable(); 
        
        $table->timestamps();
        
        // لمنع تكرار القالب لنفس الحساب ونفس اللغة
        $table->unique(['whatsapp_account_id', 'name', 'language']);
    });
}

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('whatsapp_templates');
    }
};
