<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('whatsapp_accounts', function (Blueprint $table) {
            // 🚀 إضافة حقل لتخزين حالة الـ Webhook
            // (القيم المتوقعة: active, pending, disconnected)
            // default('pending') لتوضيح أنه بانتظار تفعيل الربط الأولي
            $table->string('webhook_status')->nullable()->default('pending')->after('waba_id');
            
            // 🚀 إضافة حقل لتخزين تاريخ آخر تحديث أو فحص للحالة
            $table->timestamp('webhook_last_check_at')->nullable()->after('webhook_status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('whatsapp_accounts', function (Blueprint $table) {
            $table->dropColumn('webhook_status');
            $table->dropColumn('webhook_last_check_at');
        });
    }
};