<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('plans', function (Blueprint $table) {
            $table->id();
            $table->string('name_ar'); // اسم الباقة (عربي)
            $table->string('name_en')->nullable(); // اسم الباقة (إنجليزي)
            $table->decimal('price', 8, 2); // السعر الشهري
            $table->integer('max_whatsapp_accounts'); // عدد حسابات الواتساب المسموح بها
            $table->integer('monthly_credits'); // عدد الرسائل الشهرية أو الرصيد
            $table->text('features_ar')->nullable(); // قائمة الميزات كـ JSON (عربي)
            $table->text('features_en')->nullable(); // قائمة الميزات كـ JSON (إنجليزي)
            $table->boolean('is_visible')->default(true); // هل الباقة مرئية على صفحة الهبوط؟
            $table->boolean('is_recommended')->default(false); // هل هي الباقة الموصى بها؟
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('plans');
    }
};