<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('landing_page_settings', function (Blueprint $table) {
            $table->id();
            
            // 1. شاشة البداية (Hero Section)
            $table->string('hero_title_ar');
            $table->string('hero_subtitle_ar');
            $table->string('hero_cta_text_ar');
            $table->string('hero_image_url')->nullable(); // صورة أو فيديو توضيحي
            
            // 2. شرح النظام (Feature Highlights) - Repeater
            $table->json('main_features')->nullable(); 

            // 3. شهادات العملاء (Testimonials) - Repeater
            $table->json('testimonials')->nullable(); 
            
            // 4. الأسئلة الشائعة (FAQ) - Repeater
            $table->json('faq')->nullable();

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('landing_page_settings');
    }
};
