{{-- resources/views/auth/login.blade.php --}}

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تسجيل الدخول - WhatsMark</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet"> 
    <style>
        .primary-color { color: #3b82f6; }
        .primary-bg { background-color: #3b82f6; }
    </style>
</head>
<body class="bg-gray-100 flex items-center justify-center h-screen">

    <div class="w-full max-w-md bg-white p-8 rounded-xl shadow-2xl text-right" data-aos="fade-up">
        
        <h2 class="text-3xl font-extrabold text-gray-900 mb-6 primary-color">تسجيل الدخول</h2>
        <p class="text-gray-600 mb-8">أدخل بياناتك للوصول إلى لوحة التحكم.</p>

        <form method="POST" action="{{ route('login') }}" class="space-y-6">
            @csrf

            {{-- 1. حقل البريد الإلكتروني --}}
            <div>
                <label for="email" class="block text-sm font-medium text-gray-700 mb-2">البريد الإلكتروني</label>
                <input id="email" type="email" name="email" required autofocus 
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-blue-500 focus:border-blue-500 @error('email') border-red-500 @enderror">
                @error('email')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- 2. حقل كلمة المرور --}}
            <div>
                <label for="password" class="block text-sm font-medium text-gray-700 mb-2">كلمة المرور</label>
                <input id="password" type="password" name="password" required 
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg shadow-sm focus:ring-blue-500 focus:border-blue-500 @error('password') border-red-500 @enderror">
                @error('password')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- 3. تذكرني --}}
            <div class="flex items-center justify-between">
                <div class="text-sm">
                    @if (Route::has('password.request'))
                        <a href="{{ route('password.request') }}" class="font-medium primary-color hover:text-blue-700">
                            نسيت كلمة المرور؟
                        </a>
                    @endif
                </div>
                <div class="flex items-center space-x-2 space-x-reverse">
                    <input id="remember_me" name="remember" type="checkbox" class="h-4 w-4 primary-color border-gray-300 rounded">
                    <label for="remember_me" class="text-sm text-gray-900">
                        تذكرني
                    </label>
                </div>
            </div>

            {{-- 4. زر الدخول --}}
            <div>
                <button type="submit" class="w-full primary-bg py-2 px-4 border border-transparent rounded-lg shadow-sm text-lg font-medium text-white hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-300">
                    دخول
                </button>
            </div>
            
        </form>
        
        <div class="mt-6 text-center">
            <p class="text-sm text-gray-600">
                ليس لديك حساب؟ 
                <a href="{{ route('register') }}" class="font-medium primary-color hover:text-blue-700">
                    سجل الآن
                </a>
            </p>
        </div>

    </div>

</body>
</html>