<x-filament-panels::page class="h-screen flex flex-col">
    
    <div class="flex h-[calc(100vh-12rem)] bg-white rounded-lg shadow border overflow-hidden dark:bg-gray-900 dark:border-gray-700">
        
        {{-- القائمة الجانبية (الأسماء) --}}
        <div class="w-1/3 border-r border-gray-200 dark:border-gray-700 flex flex-col">
            <div class="p-4 border-b bg-gray-50 dark:bg-gray-800 dark:border-gray-700">
                <h3 class="font-bold">المحادثات</h3>
            </div>
            
            <div class="overflow-y-auto flex-1">
                @if($this->conversations->isEmpty())
                    <div class="p-4 text-center text-gray-500">لا توجد محادثات</div>
                @else
                    @foreach($this->conversations as $conv)
                        <div wire:click="selectContact('{{ $conv->phone }}')" 
                             class="p-4 border-b cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-800 transition 
                             {{ $selectedPhone == $conv->phone ? 'bg-blue-50 dark:bg-gray-700' : '' }}">
                            <div class="flex items-center gap-3">
                                <div class="w-10 h-10 rounded-full bg-gray-300 flex items-center justify-center">
                                    <x-heroicon-o-user class="w-6 h-6 text-gray-600"/>
                                </div>
                                <div>
                                    <p class="font-bold text-sm">{{ $conv->phone }}</p>
                                    <p class="text-xs text-gray-500">اضغط للمراسلة</p>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
        </div>

        {{-- منطقة الشات الرئيسية --}}
        <div class="w-2/3 flex flex-col bg-slate-50 dark:bg-gray-950">
            
            @if($selectedPhone)
                {{-- رأس المحادثة --}}
                <div class="p-4 bg-white border-b flex justify-between items-center dark:bg-gray-900 dark:border-gray-700">
                    <span class="font-bold text-lg">{{ $selectedPhone }}</span>
                    <span class="text-xs text-green-500 flex items-center gap-1">
                        <span class="w-2 h-2 rounded-full bg-green-500"></span> متصل
                    </span>
                </div>

                {{-- الرسائل (مع تحديث تلقائي كل 3 ثواني) --}}
                <div wire:poll.3s 
                     class="flex-1 overflow-y-auto p-4 space-y-4" 
                     id="chat-container"
                     x-data 
                     x-init="$el.scrollTop = $el.scrollHeight" {{-- نزول تلقائي للأسفل --}}
                     x-effect="$el.scrollTop = $el.scrollHeight"> {{-- عند وصول رسالة جديدة --}}
                    
                    @foreach($this->messages as $msg)
                        <div class="flex {{ $msg->direction === 'outgoing' ? 'justify-end' : 'justify-start' }}">
                            <div class="max-w-[70%] p-3 rounded-lg shadow-sm text-sm 
                                {{ $msg->direction === 'outgoing' 
                                    ? 'bg-primary-600 text-white rounded-tl-none' 
                                    : 'bg-white dark:bg-gray-800 text-gray-800 dark:text-gray-200 rounded-tr-none' }}">
                                <p>{{ $msg->body }}</p>
                                <div class="text-[10px] mt-1 opacity-70 text-right flex items-center justify-end gap-1">
                                    {{ $msg->created_at->format('H:i') }}
                                    @if($msg->direction === 'outgoing')
                                        @if($msg->status == 'read') 
                                            <x-heroicon-m-check-badge class="w-3 h-3 text-blue-200"/>
                                        @else
                                            <x-heroicon-m-check class="w-3 h-3"/>
                                        @endif
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                {{-- حقل الكتابة --}}
                <div class="p-4 bg-white border-t dark:bg-gray-900 dark:border-gray-700">
                    <form wire:submit.prevent="sendMessage" class="flex gap-2">
                        <input wire:model="messageBody" 
                               type="text" 
                               placeholder="اكتب رسالتك هنا..." 
                               class="flex-1 rounded-lg border-gray-300 focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-800 dark:border-gray-600">
                        
                        <button type="submit" class="bg-primary-600 hover:bg-primary-500 text-white px-4 py-2 rounded-lg transition">
                            <x-heroicon-m-paper-airplane class="w-5 h-5 rtl:rotate-180"/>
                        </button>
                    </form>
                </div>

            @else
                {{-- شاشة الانتظار --}}
                <div class="flex-1 flex flex-col items-center justify-center text-gray-400">
                    <x-heroicon-o-chat-bubble-left-right class="w-16 h-16 mb-4"/>
                    <p>اختر محادثة للبدء</p>
                </div>
            @endif

        </div>
    </div>
</x-filament-panels::page>