{{-- 
    ======================================
    2. قسم الميزات الرئيسية (FEATURE HIGHLIGHTS)
    ======================================
    المتغيرات المستخدمة:
    - $settings: كائن LandingPageSetting
--}}
<section class="py-20 bg-gray-100">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        
        <h2 class="text-4xl font-extrabold text-gray-900 mb-4" data-aos="fade-up">لماذا تختار نظامنا؟</h2>
        <p class="text-xl text-gray-600 mb-12 max-w-3xl mx-auto" data-aos="fade-up" data-aos-delay="100">
            أدوات مصممة خصيصاً للتسويق عبر واتساب، لضمان أعلى كفاءة وأقل تكلفة.
        </p>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-10">
            @forelse ($settings->main_features ?? [] as $feature)
                <div 
                    class="bg-white p-8 rounded-xl shadow-lg border-t-4 border-b-4 border-gray-200 hover:border-blue-500 transition duration-300 transform hover:-translate-y-1" 
                    data-aos="zoom-in" 
                    data-aos-delay="{{ ($loop->index + 1) * 150 }}"
                >
                    {{-- الأيقونة الديناميكية --}}
                    @if ($feature['icon'] ?? null)
                        {{-- 
                            🔑 ملاحظة: يجب أن تكون لديك مكوّن Blade لـ <x-icon>
                            إذا لم يكن لديك، قم بتعويضها باستخدام أيقونات SVG بسيطة أو أيقونات مكتبة خارجية
                        --}}
                        <div class="inline-block p-3 primary-text bg-blue-100 rounded-full mb-4">
                            {{-- مثال على أيقونة SVG ديناميكية باستخدام Heroicons --}}
                            <svg class="h-8 w-8" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                @if ($feature['icon'] === 'heroicon-o-arrow-path')
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m15.356 2H20M20 15h.582m-15.356 2A8.001 8.001 0 0119.418 15m-15.356 2H4"/>
                                @elseif ($feature['icon'] === 'heroicon-o-envelope')
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                                @elseif ($feature['icon'] === 'heroicon-o-chart-bar')
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0h6"/>
                                @else
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                @endif
                            </svg>
                        </div>
                    @else
                        <div class="inline-block p-3 primary-text bg-blue-100 rounded-full mb-4">
                            <svg class="h-8 w-8" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                        </div>
                    @endif

                    <h3 class="text-2xl font-bold text-gray-900 mb-3">{{ $feature['title_ar'] }}</h3>
                    <p class="text-gray-600">{{ $feature['description_ar'] }}</p>
                </div>
            @empty
                 <div class="col-span-3 text-gray-500 p-8 border border-dashed rounded-lg">
                    <p>الرجاء إضافة الميزات الرئيسية من <a href="{{ route('filament.admin.resources.landing-page-settings.edit', ['record' => 1]) }}" class="primary-text font-bold hover:underline">لوحة تحكم إعدادات صفحة الهبوط</a>.</p>
                 </div>
            @endforelse
        </div>
    </div>
</section>