<header class="sticky top-0 z-50 shadow-md transition duration-500 
               bg-white dark:bg-gray-900 border-b border-gray-100 dark:border-gray-800">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center h-16">
            
            {{-- 1. الشعار (Logo) --}}
            <a href="{{ route('landing') }}" class="flex items-center space-x-2 space-x-reverse">
                {{--  --}}
                <svg class="w-8 h-8 primary-text" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                <span class="text-xl font-extrabold text-gray-900 dark:text-white">WhatsMark</span>
            </a>

            {{-- 2. الروابط الرئيسية (Navigation) --}}
            <nav class="hidden md:flex space-x-6 space-x-reverse text-gray-600 dark:text-gray-400 font-medium">
                <a href="#features" class="hover:primary-text transition duration-300">الميزات</a>
                <a href="#pricing" class="hover:primary-text transition duration-300">الخطط</a>
                <a href="#faq" class="hover:primary-text transition duration-300">الأسئلة الشائعة</a>
            </nav>

            {{-- 3. أزرار الإجراءات (CTA & Dark Mode Toggle) --}}
            <div class="flex items-center space-x-3 space-x-reverse">
                
                {{-- تبديل الوضع الليلي (Dark Mode Toggle) --}}
                <button 
                    @click="darkMode = !darkMode" 
                    class="p-2 rounded-full text-gray-600 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-800 transition duration-300"
                >
                    <template x-if="!darkMode">
                        {{-- أيقونة الشمس (الوضع الفاتح) --}}
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z"></path></svg>
                    </template>
                    <template x-if="darkMode">
                        {{-- أيقونة القمر (الوضع الداكن) --}}
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z"></path></svg>
                    </template>
                </button>

                {{-- زر التسجيل/البدء --}}
                <a href="{{ route('register') }}" class="cta-btn py-2 px-4 text-sm font-semibold rounded-full hidden sm:inline-block">
                    ابدأ مجاناً
                </a>
            </div>
            
            {{-- زر قائمة الجوال (Hamburger Icon) --}}
            <button class="md:hidden p-2 text-gray-600 dark:text-gray-400">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path></svg>
            </button>
            
        </div>
    </div>
</header>