<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\WhatsAppAuthController;
use App\Http\Controllers\LandingPageController;
use App\Http\Controllers\Auth\RegisteredUserController; // 🔑 سنستخدم هذا بدلاً من الدالة المجهولة
use App\Models\Plan; // 🔑 استيراد موديل الباقات


// ------------------------------------------------------------------
// 1. مسارات النظام العامة (Public Routes)
// ------------------------------------------------------------------

// 🔑 مسار تبديل اللغة
Route::get('/lang/{locale}', function ($locale) {
    if (in_array($locale, ['ar', 'en'])) {
        session()->put('locale', $locale);
    }
    return back(); 
})->name('switch-language');


// 🔑 المسار الرئيسي لصفحة الهبوط (يحل محل مسار welcome القديم)
Route::get('/', [LandingPageController::class, 'index'])->name('landing');


// 🔑 مسار تسجيل الدخول (Login)
Route::get('/login', function () {
    return view('auth.login');
})->name('login');


// 🔑 مسار التسجيل (Register) - تم التعديل ليمرر الباقات
Route::get('/register', function () {
    // جلب الباقات المرئية والمتاحة للجمهور (لصفحة التسجيل)
    $plans = Plan::where('is_visible', true)
                 ->orderBy('price')
                 ->get();
                 
    return view('auth.register', compact('plans')); 
})->name('register');

// 🔑 مسار معالجة بيانات التسجيل (POST)
// يجب أن يتم إضافة هذا المسار للتعامل مع إرسال النموذج وحفظ plan_id
// سنفترض استخدام RegisteredUserController القياسي في Laravel
Route::post('/register', [RegisteredUserController::class, 'store']);


// ------------------------------------------------------------------
// 2. مسارات محمية (Authenticated Routes)
// ------------------------------------------------------------------

Route::middleware(['auth'])->group(function () {
    // مسارات ربط الواتساب
    Route::get('/admin/whatsapp/connect', [WhatsAppAuthController::class, 'connect'])->name('whatsapp.connect');
    Route::get('/admin/whatsapp/callback', [WhatsAppAuthController::class, 'callback'])->name('whatsapp.callback');
    
    // مسار لوحة التحكم الرئيسية (لوحة تحكم المستخدم)
    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');
});